#include <iostream>
#include <vector>
#include <algorithm>

int main() {
    int n;
    std::cin >> n;

    std::vector<long long> udaljenosti(n), visine(n);
    std::vector<int> indeksi(n);

    for (int i = 0; i < n; i++) {
        std::cin >> udaljenosti[i];
        indeksi[i] = i;
    }

    for (int i = 0; i < n; i++) {
        std::cin >> visine[i];
    }

    std::sort(indeksi.begin(), indeksi.end(),
        [&](int a, int b) {
            return udaljenosti[a] < udaljenosti[b];
        }
    );

    std::vector<long long> sortirane_udaljenosti(n), sortirane_visine(n);
    for (int i = 0; i < n; i++) {
        sortirane_udaljenosti[i] = udaljenosti[indeksi[i]];
        sortirane_visine[i] = visine[indeksi[i]];
    }

    std::vector<long long> izlaz(n, -1);

    for (int i = 0; i < n; i++) {
        long long visina = sortirane_visine[i];
        long long centar_x = sortirane_udaljenosti[i];

        int levi_i = -1;
        for (int j = i - 1; j >= 0; j--) {
            if (visina <= sortirane_visine[j]) {
                levi_i = j;
                break;
            }
        }

        int desni_i = -1;
        for (int j = i + 1; j < n; j++) {
            if (visina <= sortirane_visine[j]) {
                desni_i = j;
                break;
            }
        }

        if (levi_i == -1 && desni_i == -1) {
            izlaz[indeksi[i]] = -1;
            continue;
        }

        long long leva_udaljenost = -1;
        long long desna_udaljenost = -1;

        if (levi_i != -1) {
            long long visina1 = sortirane_visine[levi_i];
            long long visina2 = sortirane_visine[levi_i + 1];
            long long udaljenost_seg =
                sortirane_udaljenosti[levi_i + 1] - sortirane_udaljenosti[levi_i];

            long long tacka_preseka = (udaljenost_seg - visina1 + visina2) / 2;
            long long tacka_preseka2 = udaljenost_seg - tacka_preseka;
            long long visina_tacke_preseka = visina2 - tacka_preseka;

            leva_udaljenost =
                centar_x - sortirane_udaljenosti[levi_i]
                + visina - visina_tacke_preseka - tacka_preseka2;
        }

        if (desni_i != -1) {
            long long visina1 = sortirane_visine[desni_i - 1];
            long long visina2 = sortirane_visine[desni_i];
            long long udaljenost_seg =
                sortirane_udaljenosti[desni_i] - sortirane_udaljenosti[desni_i - 1];

            long long tacka_preseka = (udaljenost_seg + visina1 - visina2) / 2;
            long long tacka_preseka2 = udaljenost_seg - tacka_preseka;
            long long visina_tacke_preseka = visina1 - tacka_preseka;

            desna_udaljenost =
                sortirane_udaljenosti[desni_i] - centar_x
                + visina - visina_tacke_preseka - tacka_preseka2;
        }

        if (levi_i == -1) {
            izlaz[indeksi[i]] = desna_udaljenost;
        } else if (desni_i == -1) {
            izlaz[indeksi[i]] = leva_udaljenost;
        } else {
            izlaz[indeksi[i]] = std::min(leva_udaljenost, desna_udaljenost);
        }
    }

    for (int i = 0; i < n; i++) {
        std::cout << izlaz[i] << std::endl;
    }
}